%define module_name Calendar-Dates
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Role/Tiny.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.3
Release: alt1
Summary: Modules that contain calendar dates
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Calendar-Dates

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Calendar::Dates::*' namespace is reserved for modules that provide
calendar dates using a common interface. The interface is designed to be: simple
to implement, lightweight, and easy to use and export (e.g. to an iCal
calendar).

Conventions for subdivision under the `Calendar::Dates::' namespace:

=over

=item * Country-specific calendars go to <XX>::*, where <XX> is the ISO3166-1 2-letter country code

Examples:

  Calendar::Dates::SG::Events
  Calendar::Dates::SG::FestivalsEvents
  Calendar::Dates::ID::Tax

=item * Country-specific (public) holiday calendars go to XX::Holiday::*

Examples:

 Calendar::Dates::US::Holiday

=item * Region/province- and locality-specific calendars go to <CC>::<Name>::*

Examples:

 Calendar::Dates::ID::Jakarta::Events

=item * Year number can be added as the last component if the module only supports a specific year

Examples:

 Calendar::Dates::ID::Holiday::2019

=item * Religion-related calendars go to Religion::<Name>::*

Examples:

 Calendar::Dates::Religion::Christianity

=item * Sports-related calendars go to Sports::*

Examples:

 Calendar::Dates::Sports::WTA
 Calendar::Dates::Sports::WTA::2019
 Calendar::Dates::ID::Jakarta::Sports::Marathon

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/C*

%changelog
