# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/GUID.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Log/Dispatch.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Common/String.pm) perl(MooseX/Types/Log/Dispatch.pm) perl(MooseX/Types/Moose.pm) perl(Net/FTP.pm) perl(POE.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(Log/Dispatch/Array.pm)
# END SourceDeps(oneline)
%define module_version 0.002003
%define module_name Cantella-Worker
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002003
Release: alt1
Summary: Worker/Manager worker pool system
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GR/GRODITI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
package TestPreforkWorkerClass;.    use Moose;
    with 'Cantella::Worker::Role::Worker';
    has work_pile => (
      is => 'ro',
      isa => 'ArrayRef',
      default => sub{ [1..5] },
      required => 1
    );

    sub get_work {
      my $self = shift;
      return unless @{ $self->work_pile };
    }

    sub work {
      my ($self,$work) = @_;
      print STDOUT "===DOING ${work}===\n";
    }

    ############################

    my $manager = Cantella::Worker::Manager::Prefork->new(
      logger => [
        [ File => (
            filename => 'myapp-error.log',
            newline => 1,
            mode => '>>',
            min_level => 'warning'
          )
        ],
      ],
      workers => 3,
      worker_class => 'TestPreforkWorkerClass',
      max_worker_age => 300,
      close_on_call => 0,
      worker_args => {
        interval => 1,
        logger => [
          [ Screen => (newline => 1, min_level => 'debug') ],
        ],
      },
      worker_stderr_log_level => 'notice',
      worker_stdout_log_level => 'info',
    );

    $manager->start;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
