%define module_version 0.003
%define module_name Capture-Attribute
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Any/Moose.pm) perl(Attribute/Handlers.pm) perl(Capture/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Sub/Name.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: s/return/print/g
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Capture-Attribute

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Sometimes you write a function that needs to build a long string via a
convoluted series of conditional statements, loops and so on. I tend to
end up defining a variable `$return' at the top of the code,
concatenating bits to it as required, and then return it at the end. For
example:

 sub count_to_10 {
   my $return = "Listen to me count!\n";
   foreach (1..10) {
     $return .= "$_\n";
     $return .= "Half-way there!\n" if $_==5;
   }
   $return .= "All done!\n";
   return $return;
 }
 
 Mail::Message->new(
   To      => 'teacher@example.com',
   From    => 'student@example.com',
   Subject => 'I can count!',
   data    => count_to_ten(),
   )->send;

Capture::Attribute simplifies this pattern by capturing all output to
STDOUT, so you can use STDOUT as a place to capture each part of the
string.

 sub count_to_10 :Capture {
   say "Listen to me count!";
   foreach (1..10) {
     say $_;
     say "Half-way there!" if $_==5;
   }
   say "All done!";
 }
 
 Mail::Message->new(
   To      => 'teacher@example.com',
   From    => 'student@example.com',
   Subject => 'I can count!',
   data    => count_to_ten(),
   )->send;

Doesn't that look nicer?

Within a sub marked with the ":Capture" attribute, all data that would be
printed is captured instead. When the sub is finished, the return value is
ignored and the captured text is returned instead.

The `return' keyword still works just fine for its control flow purpose
inside a captured sub. The return value just doesn't get returned.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT README Changes LICENSE examples
%perl_vendor_privlib/C*

%changelog
