# BEGIN SourceDeps(oneline):
BuildRequires: perl(AppConfig.pm) perl(Bot/BasicBot.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(POE/Component/SSLify.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.1
%define module_name Capulcu-Bot
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt1
Summary: Capulcu Bot
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/O/ON/ONUR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Capulcu::Bot or simply capulcu is a highly modular IRC bot. It's a simple
and powerful bot. It's using Bot::BasicBot. Copy config.example to
~/.capulcu/config and start using bot.

Writing plugins is easy. Let's say you want to reply someone when he
says !hello. Make a perl module named Capulcu::Plugin::Hello.

  package Capulcu::Plugin::Hello;
  use Capulcu::Bot qw/match_func/;

  sub say_hello {
    return 'Hello';
  }

  match_func ('^!hello', \&say_hello);


That's it! Make sure to add this plugin to your config file. Capulcu will
say hello when someone write !hello.

Let's say you want to say hello when someone join channel. It's simple
just add join_func to your script and use it like this:

  package Capulcu::Plugin::Hello;
  use Capulcu::Bot qw/join_func/;

  sub say_hello {
    return 'Hello';
  }

  join_func (\&say_hello);

See it's simple. Capulcu is providing a complete abstraction.

Exportable functions:

=over 3

=item add_help

Add help to a commands. It's usually using after match_func. Example:

  add_help ('!hello', 'Say hello');

People can get help items with .help command. This is only builtin command
in this bot. '.help' will list available help topics and when user use
'.help !hello' he will get it's description: 'Say hello'.

=item join_func

Codeblock will run when someone joined the channel. It takes only one
parameter, ref to codeblock.

=item match_func

Codeblock will run when match. It takes two parameter, first one is regex
and second one ref to codeblock. Example:

  match_func ('^!hello', \&say_hello);

When someone say !hello it will run codeblock pointed to say_hello.

=item connect_func

Codeblock will run when bot successfully connected to server.

=item get_config

Get some configuration value. Example:

  get_config ('nick');

=item say_something

Say something to someone. It requires a hash with who, channel and body keys.
Example:

  say_something (who => 'NickServ',
                 channel => 'msg',
                 body => 'identify mypassword');

This will identify bot (Note: capulcu already have a built in identify
function).

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
