%define module_name Catalyst-ActionRole-MatchRequestAccepts
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Catalyst.pm) perl(Catalyst/Controller/ActionRole.pm) perl(Catalyst/Test.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(HTTP/Headers/Util.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Perl6/Junction.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Dispatch actions based on HTTP Accept Header
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/Catalyst-ActionRole-MatchRequestAccepts/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Lets you specify a match for the HTTP `Accept' Header, which is provided by.the the Catalyst manpage `$ctx->request->headers' object.  You might wish to instead
look at the Catalyst::Action::REST manpage if you are doing complex applications that
match different incoming request types, but if you are very fussy about how
your actions match, or if you are doing some simple ajaxy bits you might like
to use this instead of a full on package (like the Catalyst::Action::REST manpage is.)

Currently the match performed is a pure equalty, no attempt to guess or infer
matches based on similarity are done.  If you need to match several variations
you can specify all the variations with multiple attribute declarations.  Right
now we don't support expression based matching, such as `text/*', although
adding such would probably not be very hard (although I don't want to make the
logic here slow down our dispatch matching too much).

Please note that if you specify multiple `Accept' attributes on a single
action, those will be matched via an OR condition and not an AND condition.  In
other words we short circuit match the first action with at least one of the
`Accept' values appearing in the requested HTTP headers.  I think this is
correct since I imagine the purpose of multiple `Accept' attributes would be
to match several acceptable variations of a given type, not to match any of
several unrelated types.  However if you have a use case for this please let
me know.

If an action consumes this role, but no `Accept' attributes are found, the
action will simple accept all types.

For debugging purposes, if the the Catalyst manpage debug flag is enabled, you can
override the HTTP Accept header with the `http-accept' query parameter.  This
makes it easy to force detect in testing or in your browser.  This feature is
NOT available when the debug flag is off.

Also, as usual you can specify attributes and information in th configuration
of your the Catalyst::Controller manpage subclass:

    ## Set the 'our_action_json' action to consume this ActionRole.  In this
    ## example GET '/json' would only match if the client request HTTP included
    ## an Accept: application/json.

    __PACKAGE__->config(
      action_roles => ['MatchRequestAccepts'],
      action => {
        our_action_json => { Path => 'json', Accept => 'application/json' },
      });

    ## GET '/foo' will dispatch to either action 'our_action_json' or action
    ## 'our_action_html' depending on the incoming HTTP Accept.

    __PACKAGE__->config(
      action => {
        our_action_json => {
          Does => 'MatchRequestAccepts',
          Path => 'foo',
          Accept => 'application/json',
        },
        our_action_html => {
          Does => 'MatchRequestAccepts',
          Path => 'foo',
          Accept => 'text/html',
        },
      });

There's a functioning the Catalyst manpage example application in the test directory for
your review as well.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/C*

%changelog
