%define module_name Catalyst-ActionRole-QueryParameter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Test.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(HTTP/Request/Common.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Scalar/Util.pm) perl(Test/Most.pm) perl(Type/Tiny.pm) perl(Types/Standard.pm) perl(base.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Dispatch rules using query parameters
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-ActionRole-QueryParameter

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Let's you require conditions on request query parameters (as you would access.via `$ctx->request->query_parameters') as part of your dispatch matching.
This ActionRole is not intended to be used for general HTML form and parameter
processing or validation, for that purpose there are many other options (such
as the HTML::FormHandler manpage, the Data::Manager manpage or <HTML::FormFu>.)  What it can be
useful for is when you want to delegate work to various Actions inside your
Controller based on what the incoming query parameters say.

Generally speaking, it is not great development practice to abuse query
parameters this way.  However I find there is a limited and controlled subset
of use cases where this feature is valuable.  As a result, the features of this
ActionRole are  also limited to simple defined or undefined checking, and basic
Perl relational operators.

You can specify multiple `QueryParam's per Action.  If you do have more than
one we will try to match Actions that match ALL the given `QueryParam'
attributes.

There's a functioning the Catalyst manpage example application in the test directory for
your review as well.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README README.mkdn Changes
%perl_vendor_privlib/C*

%changelog
