# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/TypeKey.pm) perl(CPAN.pm) perl(Catalyst.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Exception.pm) perl(Catalyst/Plugin/Authentication/User/Hash.pm) perl(Catalyst/Test.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/Types/Common/String.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/MockObject.pm) perl(Test/MockObject/Extends.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.005
%define module_name Catalyst-Authentication-Credential-TypeKey
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: TypeKey authentication
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZD/ZDK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Authenticate Catalyst apps with TypeKey system.

Uses the Catalyst::Plugin::Authentication system.
  In MyApp.pm

  use Catalyst qw(
    ...
    Authentication
    ...
  );

  __PACKAGE__->config(
    'authentication' => {
      typekey => {
        credential => {
              class             => 'TypeKey',
              #Config below relies heavly on Authen::TypeKey
              key_cache         => '/var/cache/webapp/myapp/',
              version           => '1',
              skip_expiry_check => '1',
              key_url           => 'http://www.typekey.com/extras/regkeys.txt',
        },
        ...
      },
    },
  );


  In your controller

  sub login : Local {
    # body...
     if ( $c->authenticate( { email => $c->req->param('email') }, 'typekey') ) {
        # SUCCESS
     } else {
        # FAILED
     }
  }



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
