# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Controller/FormBuilder.pm) perl(Catalyst/Controller/FormBuilder/Action/HTML/Template.pm) perl(Catalyst/Controller/FormBuilder/Action/Mason.pm) perl(Catalyst/Controller/FormBuilder/Action/TT.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/View.pm) perl(Catalyst/View/HTML/Template.pm) perl(Catalyst/View/Mason.pm) perl(Catalyst/View/TT.pm) perl(Class/Inspector.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(Test/WWW/Mechanize/Catalyst.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Catalyst-Controller-FormBuilder-MultiForm
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Multiple forms per template with Catalyst::Controller::FormBuilder
Group: Development/Perl
License: perl
URL: https://github.com/dannywarren/Catalyst-Controller-FormBuilder-MultiForm

Source0: http://cpan.org.ua/authors/id/D/DW/DWARREN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module allows you to access multiple FormBuilder objects per template when
using Catalyst::Controller::FormBuilder (see the Catalyst::Controller::FormBuilder manpage
for more information).

By default, Catalyst::Controller::FormBuilder provides a set of variables in the
stash that you can use to access your form (default: `$c->stash->{FormBuilder}'
and `$c->stash->{formbuilder}').

If you forward to another `:Form' action, that action's FormBuilder object will
replace the FormBuilder object in your calling action.  This allows you to forward to
other actions for building form details yet keep your form handling in the calling action,
and is quite handy.

However, it prevents you from forwarding to other `:Form' actions for the purpose
of building multiple FormBuilder objects for use in a single page.

This module allows you to keep a copy of the FormBuilder object for each `:Form' action
you forward to in the stash, so that you can access multiple forms inside one template.  
Each form is kept in a stash variable (default: `$c->{forms}') and can be accessed
by the name of the form (as set in your form configuration).

For example, if you named your form `foo_edit' in your form configuration, 
you could access this form by name with the following stash variables:

  # Access the formbuilder object for the "foo_edit" form 
  $c->stash->{forms}->{foo_edit}->{FormBuilder}
  
  # Access the formbuilder data for the "foo_edit" form
  $c->stash->{forms}->{foo_edit}->{formbuilder}

If you wish to use the default behavior, just use the regular FormBuilder stash values:

  $c->stash->{FormBuilder}
  $c->stash->{formbuilder}

Since you can use both behaviors, it is safe to use this module as your base controller
without having to modify your existing single form FormBuilder code and templates.  Just
don't access the form by name, and you won't get the multiform behavior.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod Changes LICENSE
%perl_vendor_privlib/C*

%changelog
