# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Test.pm) perl(Data/MuForm.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Module/Pluggable/Object.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Template/Tiny.pm) perl(Test/Most.pm) perl(base.pm) perl(CGI/Struct/XS.pm)
# END SourceDeps(oneline)
%define module_name Catalyst-Model-Data-MuForm
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Model adaptor for Data::MuForm
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-Model-Data-MuForm

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Assuming a project namespace 'MyApp::Form' with the HTML::Formhandler manpage forms. like
the following example:
 
  package MyApp::Form::Email;
 
  use HTML::FormHandler::Moose;
 
  extends 'HTML::FormHandler';

  has 'invalid_domains' => (is=>'ro', required=>1);
  
  has_field 'email' => (
    type=>'Email',
    size => 96,
    required => 1);
 
You create a single the Catalyst manpage model like this:
 
    package MyApp::Model::Form;
 
    use Moo; # Or Moose, etc.
    extends 'Catalyst::Model::Data::MuForm';
 
    __PACKAGE__->config( form_namespace=>'MyApp::Form' );
 
(Setting 'form_namespace' is optional, it defaults to the application
namespace plus "::Form" (in this example case that would be "MyApp::Form").
 
When you start your application it will register one model for each form
in the declared namespace.  So in the above example you should see a model
'MyApp::Model::Form::Email'.
 
You can set model configuration in the normal way, in your application general
configuration:
 
    package MyApp;
    use Catalyst;
 
    MyApp->config(
      'Model::Form::Email' => {
        invalid_domains => [qw(foo.com wack.org)],
      },
    );
     
    MyApp->setup;
 
And you can pass additional args to the 'process' call of the form when you request
the form model:
 
    my $email_form = $c->model('Form::Email',
      model => $user_model,
      params => $c->req->body_parameters);
 
Basically you can pass anything you'd pass to 'process' in the Data::MuForm manpage.
 
The generated proxy will also add the ctx argument based on the current value of
$c, although using this may not be a good way to build well, decoupled applications.
 
By default if the request is a POST, we will process the request arguments and
return a form object that you can test for validity.  So you don't need to set
the 'params' if the parameters are just the existing the Catalyst manpage body_parameters.
If you don't want this behavior you can disable it by passing 'no_auto_process'.
For example:
 
    my $form = $c->model("Form::...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
