# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(Catalyst/Test.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/FormHandler.pm) perl(HTTP/Request/Common.pm) perl(Module/Pluggable.pm) perl(Moose.pm) perl(Scalar/Util.pm) perl(Test/Most.pm) perl(CGI/Struct/XS.pm)
# END SourceDeps(oneline)
%define module_version 0.009
%define module_name Catalyst-Model-HTMLFormhandler
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009
Release: alt1
Summary: Proxy a directory of HTML::Formhandler forms
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-Model-HTMLFormhandler

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Assuming a project namespace 'MyApp::Form' with the HTML::Formhandler manpage forms. like
the following example:

  package MyApp::Form::Email;

  use HTML::FormHandler::Moose;

  extends 'HTML::FormHandler';

  has aaa => (is=>'ro', required=>1);
  has bbb => (is=>'ro', required=>1);

  has_field 'email' => (
    type=>'Email',
    size => 96,
    required => 1);

You create a single the Catalyst manpage model like this:

    package MyApp::Model::Form;

    use Moose;
    extends 'Catalyst::Model::HTMLFormhandler';

    __PACKAGE__->config( form_namespace=>'MyApp::Form' );

(Setting 'form_namespace' is optional, it defaults to the application
namespace plus "::Form" (in this example case that would be "MyApp::Form").

When you start your application it will register one model for each form
in the declared namespace.  So in the above example you should see a model
'MyApp::Model::Form::Email'.  This is a 'PerRequest' model since it does
ACCEPT_CONTEXT, it will generate a new instance of the form object once
per request scope.

It will also create one model with the ::IsValid suffix, which is a shortcut
to return a form only if its valid and undef otherwise.

You can set model configuration in the normal way, in your application general
configuration:

    package MyApp;
    use Catalyst;

    MyApp->config(
      'Model::Form::Email' => { aaa => 1000 }
    );
    
    MyApp->setup;

And you can pass additional args to the 'new' call of the form when you request
the form model:

     my $email = $c->model('Form::Email', bbb=>2000);

Additional args should be in the form of a hash, as in the above example OR you can
pass a single argument which is either an object, hashref or id followed by a hash
of remaining arguements.  These first argument gets set to the item or item_id
since its common to need:

    my $email = $c->model('Form::Email', $dbic_email_row, %%args);

Or if its a HashRef, these are set to the params for processing.

The generated proxy will also add the ctx argument based on the current valu...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn README Changes LICENSE
%perl_vendor_privlib/C*

%changelog
