# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bread/Board.pm) perl(CPAN.pm) perl(Catalyst.pm) perl(Catalyst/Action/RenderView.pm) perl(Catalyst/Model/DBIC/Schema.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/ScriptRunner.pm) perl(Catalyst/Test.pm) perl(Catalyst/View/TT.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/Pg.pm) perl(DBD/SQLite.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/Types/Path/Class.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Class.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/Moose.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Catalyst-Plugin-Bread-Board
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: use Bread::Board to configure your Catalyst app
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FL/FLORA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to use Bread::Board as a replacement for you standard
Catalyst configuration. As you can see from the SYNOPSIS you subclass the
the Catalyst::Plugin::Bread::Board::Container manpage class and create your own
Bread::Board container to hold all the normal Catalyst configuration data.

At first glance this may look just like a more verbose way to write your
Catalyst configuration. And on some level that is exactly what it is
right now. (We do have plans to write something to read in those old
Catalyst configurations and turn them into Bread::Board configs like above).
But, there is more to this then just more typing, this module provides
two features which are not present in your basic Catalyst configurations.

=over 4

=item *Config info is easily accessible outside of Catalyst*

It is easy to instantiate the container completely outside of the
Catalyst application and use it in your utility scripts or in other
applications entirely. Here is an example of a parameterized container
that would allow you to use the DBIx::Class::Schema outside of
Catalyst.

  my $c = container 'DBIC' => [ 'SchemaInfo' ] => as {
      service 'schema' => (
          class => 'DBIx::Class::Schema',
          block => sub {
              my $s = shift;
              $s->param('schema_class')->connect(
                  @{ $s->param('connect_info') }
              )
          },
          dependencies => {
              schema_class => depends_on('SchemaInfo/schema_class'),
              connect_info => depends_on('SchemaInfo/connect_info'),
          }
      );
  };

  my $schema = $c->create(
      SchemaInfo => $catalyst_container->fetch('Model/DBIC')
  )->fetch('schema')->get;

There are plans to provide a set of common utility containers such as
this in the core module, look for future releases.

=item *Configurations are easily subclassable*

As discussed in the Bread::Board::Manual::Concepts::Advanced manpage it is possible
to subclass these containers in such ways that it would be possible to
essentially subclass and inherit your configurations. Here is an example
of doing just that with the container from the SYNOPSIS.

  package My::App::Extended::Container;
  use Moose;
  use Bread::Board;

  extends 'My::App::Container';

  sub BUILD {
      my $self = shift;
      $self->fetch('Model')->add_sub_container(
          container 'KiokuDB' => (
              model_class => 'My::App::Kioku::Model',
              dsn         => 'bdb:dir=root/db',
          );
      );
  }

This would give you all the same stuff as the original My::App::Container
but would also add another model.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ChangeLog README
%perl_vendor_privlib/C*

%changelog
