# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Catalyst.pm) perl(Catalyst/Component.pm) perl(Class/C3.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(NEXT.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Catalyst-Plugin-C3
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Catalyst Plugin to subvert NEXT to use Class::C3
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BL/BLBLACK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
*** WARNING *** THIS MODULE IS STILL EXPERIMENTAL !!!

This module is related to the possible transition of Catalyst from the NEXT manpage
to the Class::C3 manpage.  This transition hasn't happened yet, and might not for
a while.

This module is only intended for use by Catalyst module developers at
this time.  You would know it if you should be using this module.

*** END WARNING ***

This module makes the use of the following idiom:

  use NEXT;

  sub foo {
    my $self = shift->NEXT::foo(@_);
  }

actually accomplish something more like:

  use Class::C3;

  sub foo {
    my $self = shift->next::method(@_);
  }

It does this by temporarily replacing the AUTOLOAD entry in the NEXT manpage during the
entire the Catalyst manpage request-handling phase.  The behavior of the replacement
function is dependant upon the class (or the class of the object) that
the NEXT manpage was being called on.

If the class is not Catalyst-related, the function falls back to normal
the NEXT manpage behavior.  If the class is Catalyst-related, but its inheritance
hierarchy is not C3-compatible, the function warns about the situation
(once per class per interpreter) and again falls back to normal the NEXT manpage
behavior.

If the class is both Catalyst-related and has a C3-compatible hierarchy,
then the NEXT manpage calls are silently upgraded to their the Class::C3 manpage equivalents.

The difference between `$self->NEXT::foo()' and
`$self->NEXT::ACTUAL::foo()' is preserved (the former becomes
`maybe::next::method' and the latter becomes `next::method').

If you are going to place this module in your plugins list for
a Catalyst app, it is best placed at the top of the list, above
all other plugins.

Some other plugins may need require this plugin as a base-class in order
to transition themselves to the Class::C3 manpage without worrying about being
broken by other plugins which haven't made the transition.  Most plugins
will *not* need to do so.  Any that do would have wierd hacks involving
`*{NEXT::NEXT}' in them prior to their C3 conversion, so you'd know it.

In other words, a plugin should only base on this plugin if it
needed the NEXT manpage hacks to work right under the NEXT manpage, and you're
transitioning it to use the Class::C3 manpage.


%prep
%setup -n %module_name-%module_version
rm -f t/[0-9]-kwalitee.t t/[0-9][0-9]-kwalitee.t t/[0-9]kwalitee.t t/[0-9][0-9]kwalitee.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
