%define module_name Catalyst-Plugin-CSRFToken
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Catalyst.pm) perl(Catalyst/Test.pm) perl(Crypt/URandom.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(MIME/Base64.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/MethodAttributes.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.001
Release: alt1
Summary: Generate tokens to help prevent CSRF attacks.
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-Plugin-CSRFToken

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This uses the WWW::CSRF manpage to generate hard to guess tokens tied to a give web session.  You can
generate a token and pass it to your view layer where it should be added to the form you are
trying to process, typically as a hidden field called 'csrf_token' (althought you can change
that in configuration if needed).

Its probably best to enable 'auto_check_csrf_token' true since that will automatically check
all POST, bPUT and PATCH request (but of course if you do this you have to be sure to add the token
to every single form.  If you need to just use this on a few forms (for example you have a 
large legacy application and need to improve security in steps) you can roll your own handling
via the `check_csrf_token' method as in the example given above.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes README.mk
%perl_vendor_privlib/C*

%changelog
