# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Catalyst.pm) perl(Catalyst/Controller.pm) perl(Catalyst/View/TT.pm) perl(Class/Accessor/Fast.pm) perl(Config.pm) perl(Cwd.pm) perl(Digest/MD5.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(HTTP/Headers/ETag.pm) perl(HTTP/Status.pm) perl(List/Util.pm) perl(MRO/Compat.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Test/WWW/Mechanize/Catalyst.pm) perl(YAML/Tiny.pm) perl(ok.pm)
# END SourceDeps(oneline)
%define module_version 0.001000
%define module_name Catalyst-Plugin-Cache-HTTP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001000
Release: alt1
Summary: HTTP/1.1 cache validators for Catalyst
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GR/GRAF/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Ever since mankind develops web sites, it has to deal with the problems
that arise when a site becomes popular. This is especially true for dynamic
contents. Optimizations of the web application itself are usually followed
by tweaking the system setup, better hardware, improved connectivity,
clustering and load balancing. Good if the site yields enough profit to
fund all this (and the people that are required).

There are also numerous modules on the CPAN and helpful tips all over the
World Wide Web about how to crack the whip on Catalyst applications.

Noticeably often is overlooked, that more than a decade ago the "fathers"
of the WWW have created concepts in `HTTP/1.1' to reduce traffic between
web server and web client (and proxy where applicable). All common web
browsers support these concepts for many years now.

These concepts can accelerate a web application and save resources at the
same time.

How this is possible? You can look up the concept in RFC 2616 section 13.3,
plus the implementation in sections 14.19, 14.24, 14.25, 14.26, 14.28 and
14.44. To cut a long story short: This plugin does not manage any cache on
the server and avoids transmitting data where possible.

To utilize this concept in your Catalyst based application some rather small
additions have to be made in the code:

=over

=item 1. Use the plugin

This is easy: In the application class (often referred as MyApp.pm) just
add `Cache::HTTP' to the list of plugins after `use Catalyst'.

=item 2. Add appropriate response headers

Those headers are `Last-Modified' and `ETag'. The
headers method of Catalyst::Response
which actually provides us with an instance of HTTP::Headers
gives us two handy accessors to those header lines: `last_modified' and
`etag'.

=over

=item 2.1 `$c->response->headers->last_modified($unix_timestamp)'

If this exists in a response for a requested resource, then for the next
request to the same resource a modern web browser will add a line to the
request headers to check if the resource data has changed since the
`Last-Modified' date, that was given with the last response. If the
server answers with a status code `304' and an empty body, the browser
takes the data for this resource from its local cache.

=item 2.2 `$c->response->headers->etag($entity_tag)'

The entity tag is a unique representation of data from a resource. Usually
a digest of the response body serves well for this purpose, so for that
case whenever you read "ETag" you might replace it with "checksum". If an
`Etag' exists in a response for a requested resource, then for the next
request to the same resource the browser will add a line to the request
headers with that ETag, that tells the server to only transmit the body if
the ETag for the resource has changed. If it hasn't the server responds
with a status code `304' and an empty body, and the browser takes the
data for this resource from its local cache.

=back

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
