%define module_name Catalyst-Plugin-ServeFile
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Date.pm) perl(Moo.pm) perl(Moose.pm) perl(MooseX/MethodAttributes.pm) perl(Plack.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: A less opinionated, minimal featured way to serve static files.
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-Plugin-ServeFile

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Catalyst::Plugin::Static::Simple manpage is venerable but I find it has too many default
opinions.  I generally only use it for the simple job of when I have a single static file
or so that lives behind authentication that I want to serve.  For that simple job
the Catalyst::Plugin::Static::Simple manpage does provide a method 'serve_static_file', but there's
two problems with it.  First, the plugin out of the box will attempt to serve all files 
requested at the '/static/...' path.  If you don't want that its configuration effort.
Also, it doesn't currently support the Plack::Middleware::XSendfile manpage (Although I want to
point out adding such support would be trivial, and I would be happy to help if needed).

Even when I want the automatic serving of files under '/static' I find the old plugin
has some opinions that don't work with my expectations (for example it by default doesn't
serve *.html files).  These assumptions probably made sense in 2006 but I prefer something
with less default opinions.  So this is a plugin that just does a simple one thing.  It
gives you a method 'serve_file' which tries to safely serve a static file located in 
'$c->config->{root}', with support for the Plack::Middleware::XSendfile manpage.  It does basic
sanity / safety checking such as not allowing you to have a path with '..' for example.
And that's it.  It does automatically serve up all files under 'static', or anything.  If
you want that, use the old plugin, or write a trivial action that does it (example below).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.txt README Changes
%perl_vendor_privlib/C*

%changelog
