%define module_name Catalyst-View-BasePerRequest
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catalyst.pm) perl(CatalystX/Errors.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Tags.pm) perl(HTTP/Status.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(MooseX/MethodAttributes.pm) perl(Plack/Runner.pm) perl(Scalar/Util.pm) perl(Test/Lib.pm) perl(Test/Most.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.012
Release: alt1
Summary: Catalyst base view for per request, strongly typed templates
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Catalyst-View-BasePerRequest

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
NOTE: This is early access code.  Although it's based on several other internal projects
which have iterated over this concept for a number of years I still reserve the right
to make breaking changes as needed.

NOTE: You probably won't actually use this directly, it's intended to be a base framework
for building / prototyping strongly typed / per request views in the Catalyst manpage. This
documentation serves as an overview of the concept.  In particular please note that
this code does not address any issues around HTML / Javascript injection attacks or
provides any auto escaping. You'll need to bake those features into whatver you
build on top of this.  Because of this the following documentation is light and is mostly
intended to help anyone who is planning to build something on top of this framework
rather than use it directly.

NOTE: This distribution's `/example' directory gives you a toy prototype using the HTML::Tags manpage
as the basis to a view as well as some raw examples using this code directly (again,
not recommended for anything other than learning).

In a classic the Catalyst manpage application with server side templates, the canonical approach
is to use a 'view' as a sort of handler for an underlying template system (such as 
the Template::Toolkit manpage or the Xslate manpage) and to send data to this template by populating
the stash.  These views are very lean, and in general don't provide much in the way
of view logic processing; they generally are just a thin proxy for the underlying
templating system.

This approach has the upside of being very simple to understand and in general works
ok with a simple websites.  There are however downsides as your site becomes more
complex. First of all the stash as a means to pass data from the Controller to the
template can be fragile.  For example just making a simple typo in the stash key
can break your templates in ways that might not be easy to figure out.  Also your
template can't enforce its requirements very easily (and its not easy for ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.mkdn Changes LICENSE README example
%perl_vendor_privlib/C*

%changelog
