# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Catalyst/View.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(MRO/Compat.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Text/Markdown.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Catalyst-View-Markdown
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Markdown View Class
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WA/WALLMARI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is the Catalyst view class for Markdown.
Your application should define a view class which is a subclass of
this module. Throughout this manual it will be assumed that your application
is named MyApp and you are creating a Markdown view named MD; these names
are placeholders and should always be replaced with whatever name you've
chosen for your application and your view. The easiest way to create a Markdown
view class is through the myapp_create.pl script that is created along
with the application:

    $ script/myapp_create.pl view MD Markdown

This creates a MyApp::View::MD.pm module in the lib directory (again,
replacing `MyApp' with the name of your application) which looks
something like this:

    package FooBar::View::MD;
    use Moose;

    extends 'Catalyst::View::Markdown';

    __PACKAGE__->config(DEBUG => 'all');

Now you can modify your action handlers in the main application and/or
controllers to forward to your view class.  You might choose to do this
in the end() method, for example, to automatically forward all actions
to the Markdown view class.

    # In MyApp or MyApp::Controller::SomeController

    sub end : Private {
        my( $self, $c ) = @_;
        $c->forward( $c->view('MD') );
    }

But if you are using the standard auto-generated end action, you don't even need
to do this!

    # in MyApp::Controller::Root
    sub end : ActionClass('RenderView') {} # no need to change this line

    # in MyApp.pm
    __PACKAGE__->config(
        ...
        default_view => 'MD',
    );

This will Just Work.  And it has the advantages that:

=over 4

=item *

If you want to use a different view for a given request, just set 
<< $c->stash->{current_view} >>.  (See the Catalyst manpage's `$c->view' method
for details.

=item *

<< $c->res->redirect >> is handled by default.  If you just forward to 
`View::MD' in your `end' routine, you could break this by sending additional
content.

=back

See the Catalyst::Action::RenderView manpage for more details.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
