%define module_version 2.2
%define module_name Catalyst-View-Seamstress
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(HTML/TreeBuilder.pm)

Name: perl-%module_name
Version: 2.2
Release: alt1
Summary: HTML::Seamstress View Class for Catalyst
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DR/DRAXIL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is the Catalyst view class for HTML::Seamstress. It allows 
templating with proper seperation between code and HTML. This means you can get a 
designer/friend/client/stooge to make your templates for you without having to 
teach them a mini-language!

Your application should define a view class which is a subclass of
this module.  The easiest way to achieve this is using the
myapp_create.pl script (where myapp should be replaced with
whatever your application is called).  This script is created as part
of the Catalyst setup.

    $ script/myapp_create.pl view Seamstress Seamstress

This creates a MyApp::View::Seamstress.pm module in the 
lib directory (again, replacing `MyApp' with the name of your
application).


Now you can modify your action handlers in the main application and/or
controllers to forward to your view class.  You might choose to do this
in the end() method, for example, to automatically forward all actions
to the Seamstress view class.

    # In MyApp or MyApp::Controller::SomeController

    sub end : Private {
        my( $self, $c ) = @_;
        $c->forward('MyApp::View::Seamstress');
    }

Or you might like to use 
Catalyst::Plugin::DefaultEnd

..or even
Catalyst::Action::RenderView



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
