# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Catalyst.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/Test.pm) perl(Catalyst/View/Templated.pm) perl(Class/C3.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Pluggable/Object.pm) perl(Net/FTP.pm) perl(PadWalker.pm) perl(Socket.pm) perl(Template/Declare.pm) perl(Template/Declare/Tags.pm) perl(Test/More.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Catalyst-View-Template-Declare
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Use Template::Declare with Catalyst
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JR/JROCKWAY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Make a view:

    package MyApp::View::TD;
    use base 'Catalyst::View::Template::Declare';
    1;

Make a template:

    package MyApp::View::TD::Root;
    use Template::Declare::Tags;

    template foo => sub {
        my ($self, $c) = @_;
        html {
            head { title { $c->stash->{title} } };
            body { "Hello, world" }
          }
    };

In your app:

    $c->view('TD')->template('foo');
    $c->stash(title => 'test');
    $c->detach('View::TD');

And get the output:

    <html><head><title>test</title></head><body>Hello, world</body></html>

You can spread your templates out over multiple files.  If your
view is called MyApp::View::TD, then everything in MyApp::View::TD::*
will be included and templates declared in those files will be available
as though they were declared in your main view class.

Example:

    package MyApp::View::TD::Foo;
    use Template::Declare::Tags;
    template bar => sub { ... };
    1;

Then you can set `$c->view('TD')->template('bar')' and everything
will work as you expect.

The arguments passed to the templates are:

=over

=item `$self'

The object or package name in which the template is defined.

=item `$c'

The Catalyst context object.

=item `$stash'

A copy of the Catalyst stash, also available via `$_'. Modifications to this
copy of the stash will have no effect on the contents of `$c->stash'.

=item `$args'

Any arguments passed to `render()'.

=back

For those stuck with a version of Template::Declare older then 0.26, no
arguments will be passed to the templates. But you can still use the
otherwise-deprecated `c' package to get at the Catalyst context:

    template bar => sub { "Hello, ". c->stash->{world} };


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
