%define module_name CatalystX-Fastly-Role-Response
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Catalyst.pm) perl(Catalyst/Action/RenderView.pm) perl(Catalyst/Controller.pm) perl(Catalyst/Runtime.pm) perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/WWW/Mechanize.pm) perl(Test/WWW/Mechanize/Catalyst.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Methods for Fastly intergration to Catalyst
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LL/LLAP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This role adds methods to set appropreate cache headers in Catalyst responses,
relating to use of a Content Distribution Network (CDN) and/or Cacheing
proxy as well as cache settings for HTTP clients (e.g. web browser). It is
specifically targeted at Fastly but may also be
useful to others.

Values are converted and headers set in `finalize_headers'. Headers
affected are:

=over 4

=item -

Cache-Control: HTTP client (e.g. browser) and CDN (if Surrogate-Control not used) cache settings

=item -

Surrogate-Control: CDN only cache settings

=item -

Surrogate-Key: CDN only, can then later be used to purge content

=item -

Pragma: only set for for the browser_never_cache manpage

=item -

Expires: only for the browser_never_cache manpage

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/C*

%changelog
