Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-CatalystX-LeakChecker
Summary:        Debug memory leaks in Catalyst applications
Version:        0.06
Release:        alt2_41
License:        GPL+ or Artistic

Source0:        https://cpan.metacpan.org/authors/id/F/FL/FLORA/CatalystX-LeakChecker-%{version}.tar.gz
URL:            https://metacpan.org/release/CatalystX-LeakChecker
BuildArch:      noarch

BuildRequires:  rpm-build-perl
BuildRequires:  perl(B/Deparse.pm)
BuildRequires:  perl(Catalyst.pm)
BuildRequires:  perl(Devel/Cycle.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(Moose.pm)
BuildRequires:  perl(MooseX/AttributeHelpers.pm)
BuildRequires:  perl(MooseX/Types.pm)
BuildRequires:  perl(namespace/autoclean.pm)
BuildRequires:  perl(namespace/clean.pm)
BuildRequires:  perl(PadWalker.pm)
BuildRequires:  perl(Task/Weaken.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Text/SimpleTable.pm)

# note the explicit versioning
Requires:       perl(Catalyst.pm) >= 5.800
Requires:       perl(Devel/Cycle.pm) >= 1.110
Requires:       perl(namespace/clean.pm) >= 0.050
Requires:       perl(PadWalker.pm) >= 1.800



%{?perl_default_subpackage_tests}
Source44: import.info

%description
It's easy to create memory leaks in Catalyst applications and often
they're hard to find. This module tries to help you finding them by
automatically checking for common causes of leaks.  This module is
intended for debugging only. I suggest to not enable it in a production
environment.

%prep
%setup -q -n CatalystX-LeakChecker-%{version}

%build
%{?perl_ext_env_unset}
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/Catalyst*

%changelog
