Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: /dev/pts perl(Moose.pm) perl(Moose/Role.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-CatalystX-REPL
Version:        0.04
Release:        alt2_36
Summary:        Read-eval-print-loop for debugging your Catalyst application
License:        GPL+ or Artistic

URL:            https://metacpan.org/release/CatalystX-REPL
Source0:        https://cpan.metacpan.org/authors/id/F/FL/FLORA/CatalystX-REPL-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Carp/REPL.pm)
BuildRequires:  perl(Catalyst.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Pod/Coverage/TrustPod.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Expect.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
BuildRequires:  perl(namespace/autoclean.pm)
Requires:       perl(Catalyst.pm) >= 5.800.060


Source44: import.info

%description
Using Carp::REPL with a Catalyst application is hard. That's because of all
the internal exceptions that are being thrown and caught by Catalyst during
application startup. You'd have to manually skip over all of those.

This role works around that by automatically setting up Carp::REPL after
starting your application, if the CATALYST_REPL or MYAPP_REPL environment
variables are set.

%prep
%setup -q -n CatalystX-REPL-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
RELEASE_TESTING=1 make test

%files
%doc Changes README
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/Catalyst*

%changelog
