# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/Test.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/WWW/Mechanize/Catalyst.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm) perl(namespace/autoclean.pm) perl(strictures.pm) perl(Catalyst/Action/RenderView.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name CatalystX-Test-Most
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Test base pulling in L<Catalyst::Test>, L<Test::More>, L<Test::Fatal>, and L<HTTP::Request::Common>...
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AS/ASHLEY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use CatalystX::Test::Most "MyApp";.
 subtest "Tests with plain Catalyst::Test" => sub {
     ok request("/")->is_success, "/ is okay";
     is exception { request("/no-such-uri") }, undef,
        "404s do not throw exceptions";
     is request("/no-such-uri")->code, 404, "And do return 404";
 };

 subtest "Tests with Test::WWW::Mechanize::Catalyst" => sub {
    my $mech = mech();
    $mech->get_ok("/", "GET /");
    $mech->content_contains("OHAI", "That's my app all right");
 };

 done_testing();

 #    ok 1 - / is okay
 #    ok 2 - 404s do not throw exceptions
 #    ok 3 - And do return 404
 #    1..3
 # ok 2 - Tests with plain Catalyst::Test
 #    ok 1 - GET /
 #    ok 2 - My app all right
 #    1..2
 # ok 3 - Tests with Test::WWW::Mechanize::Catalyst


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
