%define module_version 0.07
%define module_name CatalystX-Widget-Paginator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Catalyst/Model/DBIC/Schema.pm) perl(Catalyst/Plugin/Widget.pm) perl(Catalyst/Plugin/Widget/WithResultSet.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/ScriptRunner.pm) perl(Catalyst/Test.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
BuildRequires: perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: HTML widget for digg-style paginated DBIx::ResulSet
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LO/LONERR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This widget intended to solve the general problem with paginated results.
Assume that we have a set of objects (the DBIx::Class::ResultSet manpage) and (probably)
the the Catalyst::Request manpage parameter indicates the current page. Created widget
receives resultset and additional arguments, validates pagination and can be
queried about pagination and objects presented for current page.

For the correct determination of the current page widget makes taking
the following steps:

1. Checks for constructor arguments: `page', `rows'. If specified, uses them.

2. Checks for already paginated resultset (see the DBIx::Class::ResultSet manpage
`rows' and `page' attributes for details). If specified - uses them.

3. Uses the default value for `rows' (10).

4. If attribute `page_auto' is enabled (default), try to get request parameter
named `page_arg' for `page' value.

5. Uses the default value for `page' (1).

After successful identification `page' and `rows' attributes, the widget
checks their validity for a specified resultset. Processing logic for non-valid
attributes defined by `invalid' attribute.

Created instance of a widget can be queried about its attributes.
For example: `last', `pages', `objects', etc.

Widget is converted to a string represetning the HTML table with page numbers
as links in the cells. Design details can be configured with `style' and
`style_prefix' attributes.



%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
