%define module_name Catmandu-AlephX
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Catmandu.pm) perl(Clone.pm) perl(Data/Util.pm) perl(LWP/UserAgent.pm) perl(Log/Any/Adapter/Log4perl.pm) perl(Log/Any/Test.pm) perl(Log/Log4perl.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Parser/MGC.pm) perl(Software/License.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/LWP/UserAgent.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Throwable/Error.pm) perl(URI/Escape.pm) perl(XML/LibXML.pm) perl(XML/LibXML/XPathContext.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.073
Release: alt1
Summary: turns baubles into trinkets
Group: Development/Perl
License: perl
URL: https://github.com/LibreCat/Catmandu-AlephX

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NJ/NJFRANCK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
my $aleph = Catmandu::AlephX->new(url => "http://localhost/X");
  my $item_data = $aleph->item_data(base => "rug01",doc_number => "001484477");


  #all public methods return a Catmandu::AlephX::Response
  # 'is_success' means that the xml-response did not contain the element 'error'
  # most methods return only one 'error', but some (like update_doc) multiple.
  # other errors are thrown (xml parse error, no connection ..)


  if($item_data->is_success){

    say "valid response from aleph x server";

  }else{

    say "aleph x server returned error-response: ".join("\n",@{$item_data->errors});

  }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README examples
%perl_vendor_privlib/C*

%changelog
