# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catmandu.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Throwable/Error.pm) perl(Parser/MGC.pm)
# END SourceDeps(oneline)
%define module_name Catmandu-Store-REST
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Store/retrieve items from a JSON REST-API endpoint
Group: Development/Perl
License: perl
URL: https://github.com/PACKED-vzw/Catmandu-Store-REST

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PI/PIETERDP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# From a Catmandu Fix
  lookup_in_store(
    book_id,
    REST,
    base_url: https://www.example.org/api/v1/books,
    query_string: /page/1
  )

Uses a RESTful API as a Catmandu::Store.

The module allows you to use a RESTful API that uses JSON as data format and uses the URL format
`[base_url]/[id][query_string]' as a *Store* for *Catmandu*.

Retrieving (`GET'), adding (`POST'), updating (`PUT') and deleting (`DELETE') single items is
supported. Data must be provided as JSON by the API, and the API must accept JSON for `PUT'/`POST'
requests. The URL must be of the format `[base_url]/[id][query_string]', where the `id'
is absent for `POST' requests.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/C*

%changelog
