Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Chatbot-Eliza
Version:        1.08
Release:        alt2_21
Summary:        Implementation of the Eliza algorithm
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Chatbot-Eliza
Source0:        https://cpan.metacpan.org/authors/id/G/GR/GRANTG/Chatbot-Eliza-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
# Tests:
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
This module implements the classic Eliza algorithm. The original Eliza
program was written by Joseph Weizenbaum and described in the
Communications of the ACM in 1966. Eliza is a mock Rogerian
psychotherapist. It prompts for user input, and uses a simple
transformation algorithm to change user input into a follow-up question.
The program is designed to give the appearance of understanding.

%prep
%setup -q -n Chatbot-Eliza-%{version}
cd examples
find . -type f -exec chmod a-x {} +
for i in *; do
    iconv -f latin1 -t utf8 $i > $i.utf8 && \
    touch -r $i $i.utf8 && \
    mv $i.utf8 $i
done
cd ..

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README examples
%{perl_vendor_privlib}/*

%changelog
