# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chemistry/Bond/Find.pm) perl(Chemistry/Canonicalize.pm) perl(Chemistry/File.pm) perl(Chemistry/Mol.pm) perl(Chemistry/Ring.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Parse/Yapp.pm) perl(Parse/Yapp/Driver.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Chemistry-File-SLN
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: SLN linear notation parser/writer
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IT/ITUB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module parses a SLN (Sybyl Line Notation) string. This is a File I/O
driver for the PerlMol project.  http://www.perlmol.org/. It registers the
'sln' format with Chemistry::Mol, and recognizes filenames ending in '.sln'.

Optional attributes for atoms, bonds, and molecules are stored as
$atom->attr("sln/attr"), $bond->attr("sln/attr"), and $mol->attr("sln/attr"), 
respectively. Boolean attributes are stored with a value of 'TRUE'. That's the
way boolean attributes are recognized when writing, so that they can be written
in the shortened form.

    $sln_attr->{backbone} = 1;
    # would be ouput as "C[backbone=1]"

    $sln_attr->{backbone} = 'TRUE';
    # would be ouput as "C[backbone]"

Also note that attribute names are normalized to lowercase on reading.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
