# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chemistry/File.pm) perl(Chemistry/File/PDB.pm) perl(Chemistry/MacroMol.pm) perl(Chemistry/Mol.pm) perl(Chemistry/Pattern.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Chemistry-MidasPattern
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Select atoms in macromolecules
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IT/ITUB/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module partially implements a pattern matching engine for selecting atoms
in macromolecules by using Midas/Chimera patterns. See
http://www.cmpharm.ucsf.edu/~troyer/troff2html/midas/Midas-uh-3.html#sh-2.1
for a detailed description of this language.

This module shares the same interface as the Chemistry::Pattern manpage; to perform a
pattern matching operation on a molecule, follow these steps.

1) Create a pattern object, by parsing a string. Let's assume that the pattern
object is stored in $patt and that the molecule is $mol.

2) Execute the pattern on the molecule by calling $patt->match($mol).

3) If $patt->match() returns true, extract the "map" that relates the pattern
to the molecule by calling $patt->atom_map. These method returns a list of the
atoms in the molecule that are matched by the pattern. Thus $patt->atom_map(1)
would be analogous to the $1 special variable used for regular expresion
matching. The difference between Chemistry::Pattern and Perl regular
expressions is that atoms are always captured, and that each atom always uses
one "slot".


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
