%define module_name Chess-ELO-FEDA
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/CSV.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(HTTP/Tiny.pm) perl(IO/Uncompress/Unzip.pm) perl(Spreadsheet/ParseExcel.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Download FEDA ELO (L<http://www.feda.org>) into differents backends (SQLite)
Group: Development/Perl
License: perl
URL: https://github.com/niceperl/Chess-ELO-FEDA

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NI/NICEPERL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The main idea of this module consists on build a SQL format from the XLS
downloaded from the URL provided. All players information are loaded into
"elo_feda" table, according this script:

   CREATE TABLE elo_feda(
      feda_id integer primary key, 
      surname varchar(32) not null,
      name    varchar(32), 
      fed     varchar(8), 
      rating  integer, 
      games   integer, 
      birth   integer, 
      title   varchar(16), 
      flag    varchar(8)
   );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/C*

%changelog
