%define module_version 1.03
%define module_name Chorus-Expert
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: A simple skeleton of application using one or more Chorus::Engine objects (inference engines)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IV/IVORRACH/Chorus/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Chorus::Expert does 3 simple things :

  1 - Registers one or more Chorus::Engine objects
  2 - Provides to each of them a shared working area ($SELF->BOARD)
  3 - Enter an infinite loop on each inference engine until one of them declares the system as SOLVED.

   package A;
      
   use Chorus::Engine;
   our $agent = Chorus::Engine->new();
   $agent->addrule(...);

   # --
      
   package B;
   use Chorus::Engine;
   our $agent = Chorus::Engine->new();
   $agent->addrule(...);
   
   # --
     
   use Chorus::Expert;
   use A;
   use B;
   
   my $xprt = Chorus::Expert->new();
   $xprt->register($A::agent);
   $xprt->register($B::agent);
   
   $xprt->process();


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
