# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Class-Accessor-Array-Slurpy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.020
Release: alt1
Summary: Generate accessors/constructor for array-based object (supports slurpy attribute)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Class-Accessor-Array-Slurpy

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a builder for array-backed classes. It is the same as
the Class::Accessor::Array manpage except that you can define your last (in term of the
index in array storage) attribute to be a "slurpy attribute", meaning it is an
array where its elements are stored as elements of the array storage. There can
be at most one slurpy attribute and it must be the last.

Note that without a slurpy attribute, you can still store arrays or other
complex data in your attributes. It's just that with a slurpy attribute, you can
keep a single flat array backend, so the overall number of arrays is minimized.

An example of application: tree node objects, where the first attribute (array
element) is the parent, then zero or more extra attributes, then the last
attribute is a slurpy one storing zero or more children. This is how
the Mojo::DOM manpage stores its HTML tree node, for example.

=for Pod::Coverage .+
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/C*

%changelog
