# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Class-Accessor-PackedString
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Generate accessors/constructor for object that use pack()-ed string as storage backend
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Class-Accessor-PackedString

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a builder for classes that use pack()-ed string as memory storage
backend. This is useful in situations where you need to create many (e.g.
thousands+) objects in memory and want to reduce memory usage, because
string-based objects are more space-efficient than the commonly used hash-based
objects. The downsides are: 1) you have to predeclare all the attributes of your
class along with their types (pack() templates); 2) you can only store data
which can be pack()-ed; 3) slower speed, because unpack()-ing and re-pack()-ing
are done everytime an attribute is accessed or set.

=for Pod::Coverage .+
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/C*

%changelog
