# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(Hook/AfterRuntime.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(lib.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Class-Build-Array-Glob
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Generate Class accessors/constructor (array-based object, supports globbing attribute)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Class-Build-Array-Glob

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is a class builder for array-backed classes. With it you can declare
your attributes using Moose-style `has'. Only these `has' predicates are
currently supported: `is' (ro/rw), `glob' (bool). Array index will be
determined by the order of declaration, so in the example in Synopsis, `foo'
will be stored in element 0, `bar' in element 1.

The predicate `glob' can be specified for the last attribute. It means the
attribute has an array value that are put in the end of the object backend
array's elements. So in the example in Synopsis, `baz'value's elements will
occupy object backend array's elements 2 and subsequent.

There can only be at most one attribute with glob set to true. After the
globbing attribute, there can be no more arguments (so subclassing a class with
a globbing attribute is not possible).

Note that without globbing attribute, you can still store arrays or other
complex data in your attributes. It's just that with a globbing attribute, you
can keep a single flat array backend, so the overall number of arrays is
minimized.

An example of application: tree node objects, where the first attribute (array
element) is the parent, then zero or more extra attributes, then the last
attribute is a globbing one storing zero or more children. This is how
the Mojo::DOM manpage stores its HTML tree node, for example.

=for Pod::Coverage .+
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/C*

%changelog
