Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Class-DBI-Plugin
Version:        0.03
Release:        alt2_52
Summary:        Abstract base class for Class::DBI plugins
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Class-DBI-Plugin
Source0:        https://cpan.metacpan.org/modules/by-module/Class/Class-DBI-Plugin-%{version}.tar.gz
BuildArch:      noarch
# Install
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Module
BuildRequires:  perl(Class/DBI.pm)
# Test
BuildRequires:  perl(base.pm)
BuildRequires:  perl(DBD/SQLite.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(SQL/Abstract.pm)
BuildRequires:  perl(Test/More.pm)
# Dependencies
Requires:       perl(Class/DBI.pm) >= 0.900
Source44: import.info

%description
Class::DBI::Plugin is an abstract base class for Class::DBI plugins. Its
purpose is to make writing plugins easier. Writers of plugins should be able
to concentrate on the functionality their module provides, instead of having
to deal with the symbol table hackery involved when writing a plugin module.
Only three things must be remembered:

* All methods to be exported are given the "Plugged" attribute. All other
  methods are not exported to the plugged-in class.

* Method calls that are to be sent to the plugged-in class are put in the
  init() method. Examples of these are set_sql(), add_trigger() and so on.

* The class parameter for the init() method and the "Plugged" methods is the
  plugged-in class, not the plugin class.

%prep
%setup -q -n Class-DBI-Plugin-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} -c %{buildroot}

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/Class/

%changelog
