Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DBD/SQLite.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Class-DBI-Plugin-DeepAbstractSearch
Version:        0.08
Release:        alt2_43
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
Summary:        SQL::Abstract for Class::DBI
Source:         https://cpan.metacpan.org/authors/id/S/SR/SRIHA/Class-DBI-Plugin-DeepAbstractSearch-%{version}.tar.gz
Url:            https://metacpan.org/release/Class-DBI-Plugin-DeepAbstractSearch
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Class/DBI/Plugin.pm)
BuildRequires:  perl(SQL/Abstract.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests only
BuildRequires:  perl(Class/DBI.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Class/DBI.pm) >= 0.960
Requires:       perl(Class/DBI/Plugin.pm) >= 0.020
Requires:       perl(SQL/Abstract.pm) >= 1.180



Source44: import.info
%filter_from_requires /^perl(Class.DBI.Plugin.pm)/d
%filter_from_requires /^perl(SQL.Abstract.pm)/d

%description
This plugin provides a SQL::Abstract search method for Class::DBI.  It
is similar to Class::DBI::AbstractSearch, but allows you to search and
sort by fields from joined tables.


%prep
%setup -q -n Class-DBI-Plugin-DeepAbstractSearch-%{version}
find . -type f -exec chmod -c -x {} +
find . -type f -exec perl -pi -e 's/\r//' {} +

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
