# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/Data/Inheritable.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/Builder/Module.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.00002
%define module_name Class-Data-ConfigHash
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.00002
Release: alt1
Summary: Add Catalyst-Style Config To Your Class
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DM/DMAKI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
I often times find myself wanting a per-class config that can be used to
provide sane class-level defaults, but with the ability to easily customize
the values at run time.

  package MyClass;
  __PACKAGE__->config({
    foo => 1,
    bar => 2
  });

  # Later, in perhaps an initialize hook somewhere
  my %%config = read_config_from_file() ; # say, %%config = ( foo => 3 )
  MyClass->config(\%%config);

  MyClass->config->{foo}; # yields 3
  MyClass->config->{bar}; # yields 2

The idea is that you can hardcode the defaults in your class, but you can also
easily override them by merging the original hash with a newly given hash.
This feature is handled beautifully in Catalyst.

So there, this module is basically that feature from Catalyst ripped out to a
separate module so it can be used elsewhere.

To use, simply subclass it in your module:

  package MyClass;
  use base qw(Class::Data::ConfigHash);

Done! Now you can use ->config in MyClass.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/C*

%changelog
