# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(MooseX/Declare.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Class-Discover
%define upstream_version 1.000003

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Detect MooseX::Declare's 'class' keyword in files
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/Class/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MM_Unix.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find/Rule.pm)
BuildRequires: perl(File/Find/Rule/Perl.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(PPI.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(Test/Differences.pm)
BuildRequires: perl(Test/More.pm)
BuildArch: noarch
Source44: import.info


%description
This class is designed primarily for tools that whish to populate the
'provides' field of META.{yml,json} files so that the CPAN indexer will pay
attention to the existance of your classes, rather than blithely ignoring
them.

The version parsing is basically the same as what M::I's '->version_form'
does, so should hopefully work as well as it does.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes README META.yml
%perl_vendor_privlib/*


%changelog
