%define module_version 1.002
%define module_name Class-Property
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Carp.pm) perl(Class/Accessor.pm) perl(Class/Accessor/Fast.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/Harness.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.002
Release: alt1
Summary: Perl implementation of class properties.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HU/HURRICUP/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module allows you to easily create properties for your class. It supports default, custom and lazy properties. Basically, properties are just a fancy way to access object's keys, generally means `$foo-'some_property> is equal to `$foo-'{'some_property'}>.

General syntax: 

    package Foo;
    use Class::Property;

    property(
        'name' => { 'get' => undef, 'set' => undef },               # creates default RW property, fastests
        'age' => { 'get' => undef },                                # creates default RO property
        'salary' => { 'set' => undef },                             # creates default WO property
        'weight' => { 'get' => \&weight_getter, 'set' => undef },   # creates RW property with custom getter and default setter
        'family' => { 'get_lazy' => \&read_family },                # creates RO property with lazy init method 
    );

After you've created properties for your class, you may use them as lvalues:

    use Foo;
    
    my $foo = Foo->new();
    
    $foo->name = 'Yourname';
    printf 'The age of %%s is %%s', $foo->name, $foo->age;    
    
Usually you'll need to use general syntax when you want to use custom getters/setters and/or lazy properties. To make your code cleaner, there are few helper methods:

    rw_property( 'street', 'house', 'flat' );   # creates 3 RW properties 
    ro_property( 'sex', 'height' );             # creates 2 RO properties 
    wo_property( 'relation' );                  # creates WO property
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO README Changes
%perl_vendor_privlib/C*

%changelog
