%define module_name Class-Slot
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Filter/Simple.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test2/V0.pm) perl(Type/Tiny.pm) perl(Types/Standard.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Simple, efficient, comple-time class declaration
Group: Development/Perl
License: perl
URL: https://github.com/sysread/slot

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JE/JEFFOBER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Similar to the the fields manpage pragma, `slot' declares individual fields in a
class, building a constructor and slot accessor methods.

Although not nearly as full-featured as other solutions,
`Class::Slot' is light-weight, fast, works with basic Perl objects, and
imposes no dependencies outside of the Perl core distribution. Currently, only
the unit tests require non-core packages.

`Class::Slot' is intended for use with Perl's bare metal objects. It provides
a simple mechanism for building accessor and constructor code at compile time.

It does *not* provide inheritance; that is done by setting `@ISA' or via the
`base' or `parent' pragmas.

It does *not* provide method wrappers; that is done with the `SUPER'
pseudo-class.

It *does* build a constructor method, `new', with support for default and
required slots as keyword arguments and type validation of caller-supplied
values.

It *does* build accesor methods (reader or combined reader/writer, using the
slot's name) for each slot declared, with support for type validation.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/C*

%changelog
