# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(mixin.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.15
%define module_name Class-Spiffy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: Spiffy Perl Interface Framework For You
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IN/INGY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
"Class::Spiffy" is a framework and methodology for doing object oriented
(OO) programming in Perl. Class::Spiffy combines the best parts of
Exporter.pm, base.pm, mixin.pm and SUPER.pm into one magic foundation
class. It attempts to fix all the nits and warts of traditional Perl OO,
in a clean, straightforward and (perhaps someday) standard way.

Class::Spiffy borrows ideas from other OO languages like Python, Ruby,
Java and Perl 6. It also adds a few tricks of its own.

If you take a look on CPAN, there are a ton of OO related modules. When
starting a new project, you need to pick the set of modules that makes
most sense, and then you need to use those modules in each of your
classes. Class::Spiffy, on the other hand, has everything you'll
probably need in one module, and you only need to use it once in one of
your classes. If you make Class::Spiffy the base class of the basest class
in your project, Class::Spiffy will automatically pass all of its magic to all
of your subclasses. You may eventually forget that you're even using it!

The most striking difference between Class::Spiffy and other Perl object
oriented base classes, is that it has the ability to export things. If
you create a subclass of Class::Spiffy, all the things that
Class::Spiffy exports will automatically be exported by your subclass,
in addition to any more things that you want to export. And if someone
creates a subclass of your subclass, all of those things will be
exported automatically, and so on. Think of it as "Inherited
Exportation", and it uses the familiar Exporter.pm specification syntax.

To use Class::Spiffy or any subclass of Class::Spiffy as a base class of
your class, you specify the `-base' argument to the `use' command.

    use MySpiffyBaseModule -base;

You can also use the traditional `use base 'MySpiffyBaseModule';'
syntax and everything will work exactly the same. The only caveat is
that Class::Spiffy must already be loaded. That's because Class::Spiffy
rewires base.pm on the fly to do all the Spiffy magics.

Class::Spiffy has support for Ruby-like mixins with Perl6-like roles.
Just like `base' you can use either of the following invocations:

    use mixin 'MySpiffyBaseModule';
    use MySpiffyBaseModule -mixin;

The second version will only work if the class being mixed in is a
subclass of Class::Spiffy. The first version will work in all cases, as
long as Class::Spiffy has already been loaded.

To limit the methods that get mixed in, use roles. (Hint: they work just like
an Exporter list):

    use MySpiffyBaseModule -mixin => qw(:basics x y !foo);

A useful feature of Class::Spiffy is that it exports two functions:
`field' and `const' that can be used to declare the attributes of your
class, and automatically generate accessor methods for them. The only
difference between the two functions is that `const' attributes can not
be modified; thus the accessor is much faster.

One interesting aspect of OO programming is when a method calls the same
method from a parent class. This is generally known as calling a super
method. Perl's facility for doing this is butt ugly:

    sub cleanup {
        my $self = shift;
        $self->scrub;
        $self->SUPER::cleanup(@_);
    }

Class::Spiffy makes it, er, super easy to call super methods. You just
use the `super' function. You don't need to pass it any arguments
because it automatically passes them on for you. Here's the same
function with Class::Spiffy:

    sub cleanup {
        my $self = shift;
        $self->scrub;
        super;
    }

Class::Spiffy has a special method for parsing arguments called
`parse_arguments', that it also uses for parsing its own arguments. You
declare which arguments are boolean (singletons) and which ones are
paired, with two special methods called `boolean_arguments' and
`paired_arguments'. Parse arguments pulls out the booleans and pairs
and returns them in an anonymous hash, followed by a list of the
unmatched arguments.

Finally, Class::Spiffy can export a few debugging functions `WWW',
`XXX', `YYY' and `ZZZ'. Each of them produces a YAML dump of its
arguments. WWW warns the output, XXX dies with the output, YYY prints
the output, and ZZZ confesses the output. If YAML doesn't suit your
needs, you can switch all the dumps to Data::Dumper format with the `-
dumper' option.

That's Spiffy! Pretty Classy, eh?


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
