# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/Passphrase/SaltedSHA512.pm) perl(DBD/SQLite.pm) perl(DBIx/Connector.pm) perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name Class-User-DBI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: A User class: Login credentials, roles, privileges, domains.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAVIDO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The module is designed to simplify user logins, authentication, role based
access control (authorization), as well as domain (locality) constraint access
control.

It stores user credentials, roles, and basic user information in a database via
a DBIx::Connector database connection.

User passphrases are salted with a 512 bit random salt (unique per user) using
a cryptographically strong random number generator, and converted to a SHA2-512
digest before being stored in the database.  All subsequent passphrase
validation checks test against the salt and passphrase SHA2 hash.

IP whitelists may be maintained per user.  If a user is set to require an IP
check, then the user validates only if his passphrase authenticates AND his
IP is found in the whitelist associated with his user id.

Users may be given a role, which is conceptually similar to a Unix 'group'.
Roles are simple strings.  Furthermore, multiple privileges (also simple strings)
are granted to roles.

Users may be given multiple domains, which might be used to model localities or
jurisdictions.  Domains act independently from roles and privileges, but are a
convenient way of constraining a role and its privileges to a specific set of
localities.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README examples
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
