# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Benchmark.pm) perl(Exporter.pm) perl(XSLoader.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Clone-Fast
%define upstream_version 0.97

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt5

Summary:    Natively copying Perl data structures
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/Clone/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl-devel
Source44: import.info
%description
Essentially, this module is a very optimized version of the Clone::More
manpage. By taking advantage of one of the Clone::More manpage's
'OPTIMIZATION_HACKS' as well as removing all the Pure Perl from the
'More.pm', I was able to gain a lot of speed out of the module.
Essentially, though, the core of the module is exactly as that of the
Clone::More manpage.

You will see that by useing the Benchmark::cmpthese manpage, I ran a simple
comparison between the Storable::dclone manpage, the Clone::More::clone
manpage, and the Clone::Fast::clone manpage. You will (should) begin to see
the reason why I loaded this module along side of the Clone::More manpage.

				   Rate    Storable Clone::More Clone::Fast
	Storable     7552/s          --        -39%        -59%
	Clone::More 12400/s         64%          --        -33%
	Clone::Fast 18442/s        144%         49%          --

%prep
#setup -q -n %{upstream_name}-%{upstream_version}
%setup -q -n %{upstream_name}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make

%check
# this test fails with perl >= 5.11
# https://rt.cpan.org/Ticket/Display.html?id=43248
rm t/03scalar.t
%make test || :

%install
%makeinstall_std

%files
%doc Changes META.json META.yml 
%perl_vendor_archlib/*


%changelog
