# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(PPR.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(if.pm) perl(re.pm)
# END SourceDeps(oneline)
%define module_name Code-ART
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000005
Release: alt1
Summary: Analyze/Rename/Track Perl source code
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCONWAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a range of subroutines to help you refactor
valid Perl source into cleaner, better decomposed code.

The module also comes with a Vim plugin to plumb those
refactoring behaviours directly into that editor (see the section on "Vim integration").

For example, the module provides a subroutine (`refactor_to_sub()')
that takes a source code fragment as a string, analyzes it to determine
the unbound variables within it, then constructs the source code of an
equivalent subroutine (with the unbound variables converted to
parameters) plus the source code of a suitable call to that subroutine.

It is useful when hooked into an editor, allowing you to
(semi-)automatically convert functional code like:

    my @heatmap =
        map  { $config{$_} }
        sort {
               my $a_key = $a =~ /(\d+)/ ? $1 : undef;
               my $b_key = $b =~ /(\d+)/ ? $1 : undef;
               defined $a_key && defined $b_key
                  ? $a_key <=> $b_key
                  : $a     cmp $b;
             }
        grep { /^heatmap/ }
        keys %%config;

into a much cleaner:

    my @heatmap =
        map  { $config{$_} }
        nsort
        grep { /^heatmap/ }
        keys %%config;

plus:

    sub nsort {
        sort {
               my $a_key = $a =~ /(\d+)/ ? $1 : undef;
               my $b_key = $b =~ /(\d+)/ ? $1 : undef;
               defined $a_key && defined $b_key
                  ? $a_key <=> $b_key
                  : $a     cmp $b;
        }, @_;
    }

Or to replace something long and imperative like:

    my @heatmap_keys;

    for my $key (keys %%config) {
        next if $key !~ /^heatmap/;
        push @heatmap_keys, $key;
    }

    @heatmap_keys
        = sort {
                my $a_key = $a =~ /(\d+)/ ? $1 : undef;
                my $b_key = $b =~ /(\d+)/ ? $1 : undef;
                defined $a_key && defined $b_key
                    ? $a_key <=> $b_key
                    : $a     cmp $b;
            } @heatmap_keys;

    my @heatmap;

    for (@heatmap_keys) {
  ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
