%define module_name Compress-BGZF
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Uploader.pm) perl(Compress/Zlib.pm) perl(Config.pm) perl(IO/Compress/RawDeflate.pm) perl(IO/Uncompress/RawInflate.pm) perl(List/Util.pm) perl(MetaCPAN/Client.pm) perl(Module/Build.pm) perl(Pod/Usage.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007001
Release: alt1
Summary: Read/write blocked GZIP (BGZF) files
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VO/VOLKENING/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Compress::BGZF' contains a pair of modules for working with block GZIP (BGZF) files.
BGZF is a specialized GZIP format that is compatible with existing GZIP tools
and libraries, but which allows for fast random access at the cost of a modest
increase in file size. It does this by concatenating together multiple
complete GZIP blocks, each of which has a full header and footer and thus can
be decompressed individually without reading through earlier parts of the
file, and by including an extra field in each header that contains the size of
the block. Upon creation of a Reader object, an index containing the
compressed and uncompressed offsets of the start of each block is either read
from disk or generated from the data itself. `seek', `read', and `tell' (or
their object-oriented counterparts) can then be performed on the compressed
file as if it were uncompressed. Seeks are fast, and a worst-case maximum of
64k of preceeding data will be uncompressed in order to reach the data of
interest.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/C*

%files scripts
%_bindir/*

%changelog
