%define module_name Compression-Util
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Implementation of various techniques used in data compression.
Group: Development/Perl
License: artistic_2
URL: https://github.com/trizen/Compression-Util

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TR/TRIZEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Compression::Util is a function-based module, implementing various techniques used in data compression, such as the Burrows-Wheeler transform, Move-to-front transform, Huffman Coding, Arithmetic Coding (in fixed bits), Run-length encoding, Fibonacci coding, Delta coding, LZ77/LZSS compression and LZW compression.

The provided techniques can be easily combined in various ways to create powerful compressors, such as the Bzip2 compressor, which is a pipeline of the following methods:

    1. Run-length encoding (RLE4)
    2. Burrows-Wheeler transform (BWT)
    3. Move-to-front transform (MTF)
    4. Zero run-length encoding (ZRLE)
    5. Huffman coding

This functionality is provided by the function `bz2_compress()', which can be explicitly implemented as:

    use 5.036;
    use List::Util qw(uniq);
    use Compression::Util qw(:all);

    my $data = do { open my $fh, '<:raw', $^X; local $/; <$fh> };
    my $rle4 = rle4_encode([unpack('C*', $data)]);
    my ($bwt, $idx) = bwt_encode(pack('C*', @$rle4));

    my @bytes    = unpack('C*', $bwt);
    my @alphabet = sort { $a <=> $b } uniq(@bytes);

    my $mtf = mtf_encode(\@bytes, \@alphabet);
    my $rle = zrle_encode($mtf);

    open my $out_fh, '>:raw', \my $enc;
    print $out_fh pack('N', $idx);
    print $out_fh encode_alphabet(\@alphabet);
    create_huffman_entry($rle, $out_fh);

    say "Original size  : ", length($data);
    say "Compressed size: ", length($enc);

    # Decompress the result
    bz2_decompress($enc) eq $data or die "decompression error";

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/C*

%changelog
