%define module_version 0.31
%define module_name Config-Find
%add_findreq_skiplist %perl_vendor_privlib/Config/Find/WinAny.pm
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/Spec.pm) perl(File/Which.pm) perl(IO/File.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.31
Release: alt1
Summary: Find configuration files in the native OS fashion
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SALVA/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Every OS has different rules for configuration files placement, this
module allows to easily find and create your app configuration files
following those rules.

Config::Find references configuration files by the application name or
by the application name and the configuration file name when the app
uses several application files, i.e `emacs', `profile',
`apache/httpd', `apache/ssl'.

By default the $0 value is used to generate the configuration file
name. To define it explicitly the keywords `name' or `names' have to
be used:

=over 4

=item name => `name' or `app/file'

picks the first configuration file matching that name.

=item names => [qw(foo bar foo/bar)]

picks the first configuration file matching any of the names passed.

=back

Alternatively, the exact position for the file can be specified with
the `file' keyword:

=over 4

=item file => `/config/file/name.conf'

explicit position of the configuration file.

If undef is passed this entry is ignored and the search for the
configuration file continues with the apropiate OS rules. This allows
for:

  use Config::Find;
  use Getopt::Std;

  our $opt_c;
  getopts('c:');

  my $fn=Config::Find->find(file => $opt_c)

=back

Methods in this package also accept the optional arguments `scope'
and `mode':

=over 4

=item scope => `user' or `global'

Configuration files can be private to the application user or global
to the OS, i.e. in unix there is the global `/etc/profile' and the
user `~/.profile'.

=item mode => `read' or `write'

In `read' mode already existant file names are returned, in `write'
mode the file names point to where the configuration file has to be
stored.

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/Config/Find/Win*.pm

%files
%doc Changes README
%perl_vendor_privlib/C*

%changelog
