%define module_name Config-HAProxy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Temp.pm) perl(IPC/Cmd.pm) perl(Module/Metadata.pm) perl(Text/Locus.pm) perl(Text/ParseWords.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.08
Release: alt1
Summary: Parser for HAProxy configuration file
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SG/SGRAY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Config::HAProxy class is a parser that converts the HAProxy
configuration file to a parse tree and provides methods for various
operations on this tree, such as: searching, modifying and saving it
to a file.

An object of this class contains a *parse tree* representing the
configuration read from the file (or created from scratch). Nodes in the
tree can be of four distinct classes:

=over 4

=item Empty    

Represents an empty line.
    
=item Comment

Represents a comment line.
    
=item Statement

Represents a simple statement.    

=item Section

A container, representing a `compound statement', i.e. a statement that
contains multiple sub-statements. Compound statements are: global,
defaults, frontend, and backend.    

=back

In addition to these four classes, a special class Root is provided, which
represents the topmost node in the parse tree (i.e. the parent of other nodes).

A set of attributes is associated with each node. Among these, the orig
attribute contains the original line from the configuration file that triggered
creation of this node, and locus contains the location of this line (or
lines, for sections) in the configuration file (as a Text::Locus) object.

These two attributes are meaningful for all nodes. For statement nodes (simple
statements and sections) the kw attribute contains the statement *keyword*,
and the argv attribute - its arguments. For example, the statement

    server localhost 127.0.0.1:8080

is represented by a node of class Config::HAProxy::Node::Statement, with
`server' as kw and list (`localhost', `127.0.0.1:8080') as argv.

Additionally, section nodes provide methods for accessing their subtrees.

For a detailed description of the node class and its methods, please refer to
Config::HAProxy::Node.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/C*

%changelog
