%define module_version 0.04
%define module_name Config-Interactive
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators perl(XML/Simple.pm)

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: config module with support for interpolation, XML fragments and interactive UI
Group: Development/Perl
License: Fermitools
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MP/MPG/%module_name-%module_version.tgz
BuildArch: noarch

%description
This module opens a config file and parses it's contents for you. The  *new()* method
accepts several parameters. The method  'parse'  returns a hash reference
which contains all options and it's associated values of your config file as well as comments above.
If the dialog mode is set then at the moment of parsing user will be prompted to enter different value and
if validation pattern for this particular key was defined then it will be validated and user could be asked to
enter different value if it failed.
The format of config files supported by the Config::Interactive manpage is   
`<name>=<value>' pairs or XML fragments (by the XML::Simple manpage,  namespaces are not supported) and comments are any line which starts with #.
Comments inside of XML fragments will pop-up on top of the related fragment. It will interpolate any perl variable 
which looks as ` ${?[A-Za-z]\w+}? '.
Please not that interpolation works for XML fragments as well, BUT interpolated varialbles MUST be defined
by `key=value' definition and NOT inside of other XML fragment!
The order of appearance of such variables in the config file is not important, means you can use `$bar' variable anywhere in the config file but
set it to something on the last line (or even skip setting it at all , then it will be undef).
It stores internally config file contents as hash ref where data structure is:
Please note that array ref is used to store XML text elements and scalar for attributes.

   
   ( 'key1' => {'comment' => "#some comment\n#more comments\n", 
                'value' => 'Value1',
                'order' => '1',
              },
   'key2' => {'comment' => "#some comment\n#more comments\n", 
              'value' =>  'Value2',
              'order' => '2'
             },
    
   'XMLRootKey' =>  {'comment' => "#some comment\n#more comments\n",
                     'order' => '3',
                     'value' =>  { 
                                   'xmlAttribute1' => 'attribute_value',
                                   'subXmlKey1' =>    ['sub_xml_value1'],
                                   'subXmlKey2' =>    ['sub_xml_value2'],
                                   'subXmlKey3'=>     ['sub_xml_value3'],_
                   }_      
     }
   ) 
  

The normalized ( flat hash with only key=value pairs ) view of the config could be obtained by getNormalizedData() call.
All tree- like options will be flatted as key1_subkey1_subsubkey1. So the structure above will be converted into:

  ('key1' => 'Value1', 
   'key2' =>   'Value2', 
   'XMLRootKey_xmlAttribute1' => 'attribute_value',
   'XMLRootKey_subXmlKey1' =>  'sub_xml_value1' ,
   'XMLRootKey_subXmlKey2' =>   'sub_xml_value2',
   'XMLRootKey_subXmlKey3'=>    'sub_xml_value3' , )    

the case of the key will be preserved.___


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/C*

%changelog
