Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Term/ReadLine/Perl.pm) perl(Test/Perl/Critic.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# The test fuse_ui.t doesn't work in mock, they can be run on local machine
%bcond_with test_fuse

Name:           perl-Config-Model
Version:        2.153
Release:        alt1_3
Summary:        Framework to create configuration validation tools and editors
License:        LGPL-2.1-or-later

URL:            https://metacpan.org/release/Config-Model
Source0:        https://cpan.metacpan.org/authors/id/D/DD/DDUMONT/Config-Model-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(base.pm)
BuildRequires:  perl(boolean.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Carp/Assert/More.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Config/Model/Tester.pm)
BuildRequires:  perl(Config/Model/Tester/Setup.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/testlib.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(feature.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/HomeDir.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(Fuse.pm)
BuildRequires:  perl(Hash/Merge.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(JSON.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(List/MoreUtils.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Log/Log4perl.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Mouse.pm)
BuildRequires:  perl(Mouse/Role.pm)
BuildRequires:  perl(Mouse/Util.pm)
BuildRequires:  perl(Mouse/Util/TypeConstraints.pm)
BuildRequires:  perl(MouseX/NativeTraits.pm)
BuildRequires:  perl(MouseX/StrictConstructor.pm)
BuildRequires:  perl(open.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Parse/RecDescent.pm)
BuildRequires:  perl(Path/Tiny.pm)
BuildRequires:  perl(Pod/POM.pm)
BuildRequires:  perl(Pod/Simple.pm)
BuildRequires:  perl(Pod/Text.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Regexp/Common.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Term/ReadLine.pm)
BuildRequires:  perl(Term/ReadLine/Gnu.pm)
# Term::ReadLine::Perl - not used
BuildRequires:  perl(Test/Differences.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/File/Contents.pm)
BuildRequires:  perl(Test/Log/Log4perl.pm)
BuildRequires:  perl(Test/Memory/Cycle.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Synopsis/Expectation.pm)
BuildRequires:  perl(Test/Warn.pm)
BuildRequires:  perl(Text/Levenshtein/Damerau.pm)
BuildRequires:  perl(Text/Wrap.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XXX.pm)
BuildRequires:  perl(YAML/Tiny.pm)
%if %{with test_fuse}
BuildRequires:  fuse
BuildRequires:  kmod
%endif
Requires:       perl(MouseX/NativeTraits.pm)
Requires:       perl(Text/Levenshtein/Damerau.pm)

# RPM 4.8 filters
# Fedora is not a Debian system
%filter_from_requires /perl.AptPkg.Config.pm./d; /perl.AptPkg.System.pm./d; /perl.AptPkg.Version.pm./d

# RPM 4.9 filters


Source44: import.info


%description
Using Config::Model, a typical configuration validation tool will be made
of 3 parts :
1. The user interface
2. The validation engine which is in charge of validating all the 
configuration information provided by the user.
3. The storage facility that store the configuration information

%prep
%setup -q -n Config-Model-%{version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
unset TEST_AUTHOR
%if %{with test_fuse}
modprobe fuse
%endif
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes MODELS README.md TODO CONTRIBUTING.md
%{perl_vendor_privlib}/*

%changelog
